//
//  GSFontInfoValue.h
//  GlyphsCore
//
//  Created by Georg Seifert on 12.05.18.
//  Copyright © 2018 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <GlyphsCore/GSBase.h>

@class GSCustomParameter;
@class GSFont;
@protocol GSContainerProtocol;

@interface GSFontInfoValue : NSObject <NSCopying>

/**
 @see `-[GSFont(SerialImport) initWithGlyphsFile:error:]`
 */
@property (nonatomic, weak) id<GSContainerProtocol> parent;

@property (nonatomic, readonly) NSString *key;

@property (nonatomic, copy) NSString *value;
@property (nonatomic, copy) NSString *languageTag;

@property (nonatomic, readonly) BOOL isDefault;

- (instancetype)initWithValue:(NSString *)value
				  languageTag:(NSString *)languageTag;

- (instancetype)initWithDict:(NSDictionary *)dict
					  format:(GSFormatVersion)formatVersion;

- (NSDictionary *)propertyListValueFormat:(GSFormatVersion)formatVersion;

- (BOOL)saveToFile:(FILE *)file
			format:(GSFormatVersion)formatVersion
			 error:(NSError **)error;

@end
